/*
Product Name: Windz App
Author: KodingStudio
Website: https://kodingstudio.com/
Contact: contact@kodingstudio.com
File: Agent Js File
*/


let idField = document.getElementById("id-field"),
    inputDeleteId = document.getElementById("input-delete-id"),
    statusField = document.getElementById("status-field"),
    inputName = document.getElementById("input-name"),
    inputUsername = document.getElementById("input-username"),
    addBtn = document.getElementById("add-btn"),
    editBtn = document.getElementById("edit-btn"),
    deleteRecordBtn = document.getElementById('delete-record');

let fromLat = 0.0,
    fromLng = 0.0,
    toLat = 0.0,
    toLng = 0.0;

const inputFromLocation = document.getElementById("input-from-location"),
    inputToLocation = document.getElementById("input-to-location");

let selectorBusiness = document.getElementById('choice-business');
let choiceBusiness = new Choices(selectorBusiness, {
    searchEnabled: true
});

let selectorGroup = document.getElementById('choice-group');
let choiceGroup = new Choices(selectorGroup, {
    searchEnabled: true
});

let selectorUser = document.getElementById('choice-user');
let choiceUser = new Choices(selectorUser, {
    searchEnabled: true
});

let statusVal = new Choices(statusField);

// list js
let checkAll = document.getElementById("checkAll");
if (checkAll) {
    checkAll.onclick = function () {
        var checkboxes = document.querySelectorAll('.form-check-all input[type="checkbox"]');
        if (checkAll.checked == true) {
            Array.from(checkboxes).forEach(function (checkbox) {
                checkbox.checked = true;
                checkbox.closest("tr").classList.add("table-active");
            });
        } else {
            Array.from(checkboxes).forEach(function (checkbox) {
                checkbox.checked = false;
                checkbox.closest("tr").classList.remove("table-active");
            });
        }
    };
}

let perPage = 8;

//Table
let options = {
    valueNames: [
        "id",
        "booking_id",

        "business_id",
        "business_name",

        "group_id",
        "group_name",

        "people_id",
        "people_name",

        "from_address",
        "to_address",

        "estimated_duration",
        "estimated_distance",
        "estimated_fare",

        "date",
        "status",
    ],
    page: perPage,
    pagination: true,
    plugins: [
        ListPagination({
            left: 2,
            right: 2
        })
    ]
};

// Init list
let customerList = new List("customerList", options).on("updated", function (list) {
    list.matchingItems.length == 0 ?
        (document.getElementsByClassName("noresult")[0].style.display = "block") :
        (document.getElementsByClassName("noresult")[0].style.display = "none");
    var isFirst = list.i == 1;
    var isLast = list.i > list.matchingItems.length - list.page;
    // make the Prev and Nex buttons disabled on first and last pages accordingly
    (document.querySelector(".pagination-prev.disabled")) ? document.querySelector(".pagination-prev.disabled").classList.remove("disabled") : '';
    (document.querySelector(".pagination-next.disabled")) ? document.querySelector(".pagination-next.disabled").classList.remove("disabled") : '';

    if (isFirst) {
        document.querySelector(".pagination-prev").classList.add("disabled");
    }
    if (isLast) {
        document.querySelector(".pagination-next").classList.add("disabled");
    }

    if (list.matchingItems.length <= perPage) {
        document.querySelector(".pagination-wrap").style.display = "none";
    } else {
        document.querySelector(".pagination-wrap").style.display = "flex";
    }

    if (list.matchingItems.length == perPage) {
        document.querySelector(".pagination.listjs-pagination").firstElementChild.children[0].click()
    }

    if (list.matchingItems.length > 0) {
        document.getElementsByClassName("noresult")[0].style.display = "none";
    } else {
        document.getElementsByClassName("noresult")[0].style.display = "block";
    }
});

/* fetch active business endpoint */
function fetchBranchEndpoint(url= baseUrl + 'v1/web/business/active') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201 || 204) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}

/* fetch specific category product endpoint */
function fetchSpecificBusinessGroupsEndpoint(url ) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201 || 204) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}

/* fetch all endpoint */
function fetchAllEndpoint(url=baseUrl + 'v1/web/parcel/all') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}

/* add endpoint */
function addEndpoint(jsonParam, url = baseUrl + 'v1/web/booking/add') {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

/* update endpoint */
function updateEndpoint(jsonParam, url) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("POST", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send(JSON.stringify(jsonParam));

    });

}

/* delete endpoint */
function deleteEndpoint(url) {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200 || status === 201) {
                resolve({code: status, data: this.responseText});
            } else {
                reject({code: status, data: this.responseText});
            }

        };
        xhttp.open("GET", url, true);
        for (let i = 0; i < listOfHeaders.length; i++) {
            xhttp.setRequestHeader(listOfHeaders[i]['key'], listOfHeaders[i]['value']);
        }

        xhttp.send();

    });

}


/*fetchBranchEndpoint()
    .then(response => JSON.parse(response.data))
    .then(data => {

        let dataList = [];
        Array.from(data.data).forEach(raw => {

            const param = {
                label: raw.name,
                value: raw.id
            };
            dataList.push(param);

        });

        choiceBusiness.setChoices(
            dataList,
            'value',
            'label',
            false,
        );


    })
    .catch(error => {

        let data = JSON.parse(error.data);
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: data.message,
            showConfirmButton: false,
            timer: 2000,
            showCloseButton: true
        });
        customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');

    });*/

fetchAllEndpoint()
    .then(response => JSON.parse(response.data))
    .then(data => {

        if (data.data.length <= 0)
            customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');

        Array.from(data.data).forEach(raw => {

            let dateCreated = moment(raw.created_at, "YYYY-MM-DD hh:mm:ss").format("DD MMM, YYYY");
            customerList.add({
                id: '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ' + raw.id + "</a>",

                business_id: raw.business_id,
                business_name: raw.business_name,

                group_id: raw.group_id,
                group_name: raw.group_name,

                people_id: raw.people_id,
                people_name: raw.people_name,

                from_address: raw.from_location,
                to_address: raw.to_location,

                estimated_fare: raw.estimated_fare,
                estimated_distance: raw.estimated_distance,
                estimated_duration: raw.estimated_duration,

                date: dateCreated,
                status: isStatus(raw.status)
            });

        });

        customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');
        customerList.sort('id', {order: "desc"});
        addActiveClassToCheckbox();
        refreshCallbacks();

    })
    .catch(error => {

        let data = JSON.parse(error.data);
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: data.message,
            showConfirmButton: false,
            timer: 2000,
            showCloseButton: true
        });
        customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ2101</a>');

    });


document.getElementById('create-btn')
    .addEventListener("click", function (e) {

        window.location.assign("add_parcel_booking.php");

});

/*addBtn.addEventListener("click", function (e) {

    if (inputFromLocation.value !== null &&
        inputToLocation.value !== null &&
        choiceBusiness.getValue(true) !== "" &&
        choiceGroup.getValue(true) !== "" &&
        choiceUser.getValue(true) !== "" &&
        statusVal.getValue(true) !== "") {


        addEndpoint({
            business_id: choiceBusiness.getValue(true),
            group_id : choiceGroup.getValue(true),
            people_id : choiceUser.getValue(true),
            from_location : inputFromLocation.value,
            to_location: inputToLocation.value,
            from_lat: fromLat,
            from_lng: fromLng,
            to_lat: toLat,
            to_lng: toLng,
        })
            .then(response => JSON.parse(response.data))
            .then(data => {

                let dataObject = data.data;
                let dateCreated = moment(dataObject.created_at, "YYYY-MM-DD hh:mm:ss").format("DD MMM, YYYY");

                customerList.add({
                    id: '<a href="javascript:void(0);" class="fw-medium link-primary">#VZ' + dataObject.id + "</a>",
                    business_id: choiceBusiness.getValue()['value'],
                    business_name: choiceBusiness.getValue()['label'],

                    group_id: choiceGroup.getValue()['value'],
                    group_name: choiceGroup.getValue()['label'],

                    people_id: choiceUser.getValue()['value'],
                    people_name: choiceUser.getValue()['label'],

                    from_address: inputFromLocation.value,
                    to_address: inputToLocation.value,

                    date: dateCreated,
                    status: isStatus(statusField.value),
                });

                customerList.sort('id', {order: "desc"});
                document.getElementById("close-modal").click();
                clearFields();
                filterContact("All");
                refreshCallbacks();

                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Added successfully!',
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });

            })
            .catch(error => {

                let data = JSON.parse(error.data);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: data.message,
                    showConfirmButton: false,
                    timer: 2000,
                    showCloseButton: true
                });

            });


    }
});
editBtn.addEventListener("click", function (e) {

    let itemId = idField.value;
    var editValues = customerList.get({
        id: itemId,
    });
    Array.from(editValues).forEach(function (x) {
        isid = new DOMParser().parseFromString(x._values.id, "text/html");
        var selectedid = isid.body.firstElementChild.innerHTML;
        if (selectedid === itemId) {

            let id = itemId.replace('#VZ', '');
            let json = {
                business_id: choiceBusiness.getValue()['value'],
                group_id: choiceGroup.getValue()['value'],
                name: inputName.value,
                enable: getStatus(statusField.value)
            };
            updateEndpoint(json,
                baseUrl + 'v1/web/people/update/'+id)
                .then(response => JSON.parse(response.data))
                .then(data => {

                    let dateCreated = moment().format("DD MMM, YYYY");
                    x.values({
                        id: '<a href="javascript:void(0);" class="fw-medium link-primary">' + idField.value + "</a>",
                        business_id: choiceBusiness.getValue()['value'],
                        business_name: choiceBusiness.getValue()['label'],
                        group_id: choiceGroup.getValue()['value'],
                        group_name: choiceGroup.getValue()['label'],
                        name: inputName.value,
                        username: inputUsername.value,
                        date: dateCreated,
                        status: isStatus(statusField.value),
                    });

                    document.getElementById("close-modal").click();
                    clearFields();
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: data.message,
                        showConfirmButton: false,
                        timer: 2000,
                        showCloseButton: true
                    });

                })
                .catch(error => {

                    let data = JSON.parse(error.data);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: data.message,
                        showConfirmButton: false,
                        timer: 2000,
                        showCloseButton: true
                    });

                })


        }
    });

});
deleteRecordBtn.addEventListener("click", function () {

    let id = inputDeleteId.value;
    deleteEndpoint(baseUrl + 'v1/web/people/delete/' + id.replace('#VZ', ''))
        .then(response => JSON.parse(response.data))
        .then(data => {

            customerList.remove("id", '<a href="javascript:void(0);" class="fw-medium link-primary">' + id + '</a>');
            document.getElementById("deleteRecordModal").click();
            Swal.fire({
                position: 'center',
                icon: 'success',
                title: data.message,
                showConfirmButton: false,
                timer: 2000,
                showCloseButton: true
            });
            clearFields();

        })
        .catch(error => {

            let data = JSON.parse(error.data);
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: data.message,
                showConfirmButton: false,
                timer: 2000,
                showCloseButton: true
            });

        });

});*/


document.querySelector(".pagination-next").addEventListener("click", function () {
    (document.querySelector(".pagination.listjs-pagination")) ? (document.querySelector(".pagination.listjs-pagination").querySelector(".active")) ?
        document.querySelector(".pagination.listjs-pagination").querySelector(".active").nextElementSibling.children[0].click() : '' : '';
});
document.querySelector(".pagination-prev").addEventListener("click", function () {
    (document.querySelector(".pagination.listjs-pagination")) ? (document.querySelector(".pagination.listjs-pagination").querySelector(".active")) ?
        document.querySelector(".pagination.listjs-pagination").querySelector(".active").previousSibling.children[0].click() : '' : '';
});

document.getElementById("showModal").addEventListener("show.bs.modal", function (e) {

    initAutocomplete();

    if (e.relatedTarget.classList.contains("edit-item-btn")) {
        document.getElementById("exampleModalLabel").innerHTML = "Edit Booking";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "block";
        document.getElementById("add-btn").style.display = "none";
        document.getElementById("edit-btn").style.display = "block";
    }
    else if (e.relatedTarget.classList.contains("add-btn")) {
        document.getElementById("exampleModalLabel").innerHTML = "Add Booking";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "block";
        document.getElementById("edit-btn").style.display = "none";
        document.getElementById("add-btn").style.display = "block";
    }
    else {
        document.getElementById("exampleModalLabel").innerHTML = "List Currency";
        document.getElementById("showModal").querySelector(".modal-footer").style.display = "none";
    }

});
document.getElementById("showModal").addEventListener("hidden.bs.modal", function () {
    clearFields();
});



/* filter data using any specific value*/
function filterContact(isValue) {
    var values_status = isValue;
    customerList.filter(function (data) {
        var statusFilter = false;
        matchData = new DOMParser().parseFromString(
            data.values().status,
            "text/html"
        );
        var status = matchData.body.firstElementChild.innerHTML;
        if (status == "All" || values_status == "All") {
            statusFilter = true;
        } else {
            statusFilter = status == values_status;
        }
        return statusFilter;
    });

    customerList.update();
}

/* searching the data in the table*/
function SearchData() {

    var isstatus = document.getElementById("idStatus").value;
    var pickerVal = document.getElementById("datepicker-range").value;

    var date1 = pickerVal.split(" to ")[0];
    var date2 = pickerVal.split(" to ")[1];
    if (date2 == null)
        date2 = date1;

    console.log("Date 01 = " + date1 + " Date 02 = " + date2);

    customerList.filter(function (data) {
        matchData = new DOMParser().parseFromString(data.values().status, 'text/html');
        var status = matchData.body.firstElementChild.innerHTML;
        var statusFilter = false;
        var dateFilter = false;

        if (status == 'all' || isstatus == 'all') {
            statusFilter = true;
        } else {
            statusFilter = status == isstatus;
        }

        if (new Date(data.values().date.slice(0, 12)) >= new Date(date1) && new Date(data.values().date.slice(0, 12)) <= new Date(date2)) {
            dateFilter = true;
        } else {
            dateFilter = false;
        }

        if (statusFilter && dateFilter) {
            return statusFilter && dateFilter
        } else if (statusFilter && pickerVal == "") {
            return statusFilter
        } else if (dateFilter && pickerVal == "") {
            return dateFilter
        }
    });
    customerList.update();
}

/* clear the dialog fields*/
function clearFields() {

    statusField.value = "";

    statusVal.setChoiceByValue("");
    choiceBusiness.setChoiceByValue("");
    choiceGroup.setChoiceByValue("");
    choiceUser.setChoiceByValue("");

    inputName.value = '';
    inputUsername.value = '';

    inputUsername.disabled = false;

    inputFromLocation.value = '';
    inputToLocation.value = '';

    fromLat = 0.0;
    fromLng = 0.0;
    toLat = 0.0;
    toLng = 0.0;

}

/* delete the multiple data from list*/
function deleteMultiple() {
    ids_array = [];
    var items = document.getElementsByName('chk_child');
    Array.from(items).forEach(function (ele) {
        if (ele.checked == true) {
            var trNode = ele.parentNode.parentNode.parentNode;
            var id = trNode.querySelector('.id a').innerHTML;
            ids_array.push(id);
        }
    });
    if (typeof ids_array !== 'undefined' && ids_array.length > 0) {
        if (confirm('Are you sure you want to delete this?')) {
            Array.from(ids_array).forEach(function (id) {
                customerList.remove("id", `<a href="javascript:void(0);" class="fw-medium link-primary">${id}</a>`);
            });
            document.getElementById('checkAll').checked = false;
        } else {
            return false;
        }
    } else {
        Swal.fire({
            title: 'Please select at least one checkbox',
            confirmButtonClass: 'btn btn-info',
            buttonsStyling: false,
            showCloseButton: true
        });
    }
}

/* get the decorated status regaridng status value*/
function isStatus(val) {
    switch (val) {
        case "Active":
            return (
                '<span class="badge badge-soft-success text-uppercase">' +
                val +
                "</span>"
            );
        case "Block":
            return (
                '<span class="badge badge-soft-danger text-uppercase">' +
                val +
                "</span>"
            );

        case 0:
            return (
                '<span class="badge badge-soft-info text-uppercase">' +
                'Pending' +
                "</span>"
            );
        case 1:
            return (
                '<span class="badge badge-soft-success text-uppercase">' +
                'Accepted' +
                "</span>"
            );
    }
}

function getStatus(val) {
    switch (val) {
        case "Active":
            return 0;
        case "Block":
            return 1;
    }
}

/* Add click listener to checkbox
 also attach/remove the active class into checkbox */
function addActiveClassToCheckbox() {
    Array.from(document.getElementsByName("checkAll")).forEach(function (x) {
        x.addEventListener("click", function (e) {
            if (e.target.checked) {
                e.target.closest("tr").classList.add("table-active");
            } else {
                e.target.closest("tr").classList.remove("table-active");
            }
        });
    });
}

/* Attach the listeners to delete/edit buttons of table */
function refreshCallbacks() {

    const fromCells = document.querySelectorAll(".from_address");
    fromCells.forEach(cell => {
        const fullText = cell.textContent.trim();

        // Truncate content visually
        cell.style.maxWidth = "200px";       // adjust width as needed
        cell.style.whiteSpace = "nowrap";
        cell.style.overflow = "hidden";
        cell.style.textOverflow = "ellipsis";
        cell.style.cursor = "pointer";

        // Set tooltip
        cell.setAttribute("title", fullText);
        cell.setAttribute("data-bs-toggle", "tooltip");

        // Make tooltip clickable
        cell.addEventListener("click", () => {

            // Copy to clipboard
            navigator.clipboard.writeText(fullText).then(() => {
                // Optionally change tooltip to indicate copy success
                const tooltip = bootstrap.Tooltip.getInstance(cell);
                tooltip.setContent({ '.tooltip-inner': 'Copied!' });
                tooltip.show();

                // Restore original title after 1.5s
                setTimeout(() => {
                    tooltip.setContent({ '.tooltip-inner': fullText });
                }, 1500);


            });

        });

    });

    const toCells = document.querySelectorAll(".to_address");
    toCells.forEach(cell => {
        const fullText = cell.textContent.trim();

        // Truncate content visually
        cell.style.maxWidth = "200px";       // adjust width as needed
        cell.style.whiteSpace = "nowrap";
        cell.style.overflow = "hidden";
        cell.style.textOverflow = "ellipsis";
        cell.style.cursor = "pointer";

        // Set tooltip
        cell.setAttribute("title", fullText);
        cell.setAttribute("data-bs-toggle", "tooltip");

        // Make tooltip clickable
        cell.addEventListener("click", () => {

            // Copy to clipboard
            navigator.clipboard.writeText(fullText).then(() => {
                // Optionally change tooltip to indicate copy success
                const tooltip = bootstrap.Tooltip.getInstance(cell);
                tooltip.setContent({ '.tooltip-inner': 'Copied!' });
                tooltip.show();

                // Restore original title after 1.5s
                setTimeout(() => {
                    tooltip.setContent({ '.tooltip-inner': fullText });
                }, 1500);


            });

        });

    });

    // Initialize Bootstrap tooltips
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.forEach(el => new bootstrap.Tooltip(el));

    /*Array.from(document.getElementsByClassName("remove-item-btn")).forEach(function (btn) {

        if (btn.getAttribute('listener') == 'false') {

            btn.setAttribute('listener', 'true');
            btn.addEventListener("click", function (e) {

                let itemIdRemove = e.target.closest("tr").children[1].innerText;
                let itemValuesRemove = customerList.get({
                    id: itemIdRemove,
                });

                Array.from(itemValuesRemove).forEach(function (x) {

                    let idDelete = new DOMParser().parseFromString(x._values.id, "text/html");
                    let isdeleteid = idDelete.body.firstElementChild.innerHTML;

                    if (isdeleteid === itemIdRemove) {

                        inputDeleteId.value = isdeleteid;

                    }

                });

            });

        }

    });
    Array.from(document.getElementsByClassName("edit-item-btn")).forEach(function (btn) {

        if (btn.getAttribute('listener') == 'false') {

            btn.setAttribute('listener', 'true');
            btn.addEventListener("click", function (e) {

                let itemIdEdit = e.target.closest("tr").children[1].innerText;
                let itemValuesEdit = customerList.get({
                    id: itemIdEdit,
                });

                Array.from(itemValuesEdit).forEach(function (x) {
                    let idEdit = new DOMParser().parseFromString(x._values.id, "text/html");
                    let selectedid = idEdit.body.firstElementChild.innerHTML;
                    if (selectedid === itemIdEdit) {


                        idField.value = selectedid;
                        choiceBusiness.setChoiceByValue(x._values.business_id);
                        getSpecificBusinessGroup(true, x._values.group_id);
                        inputName.value = x._values.name;
                        inputUsername.value = x._values.username;
                        inputUsername.disabled = true;

                        if (statusVal) statusVal.destroy();
                        statusVal = new Choices(statusField, {
                            searchEnabled: false
                        });
                        val = new DOMParser().parseFromString(x._values.status, "text/html");
                        var statusSelec = val.body.firstElementChild.innerHTML;
                        statusVal.setChoiceByValue(statusSelec);


                    }
                });
            });

        }

    });*/

}



