/*

Product Name: PosPlatter
Author: KodingStudio
Website: https://posplatter.com/
Contact: contact@kodingstudio.com
File: Login Js File

*/

// variable for main endpoints

// Personal Detail - Start
// variable for personal details

let inputPersonalEmail = document.getElementById('input-personal-email');
let btnSubmit = document.getElementById('btn-continue');

// variable for feedback / error variables

    let feedbackPersonalEmail = document.getElementById('feedback-personal-email');

// Personal Detail - End

/* verify business credentials RestApi Endpoint */
function forgotUserEndpoint(jsonParam, url) {

    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200) {
                resolve(this.responseText);
            } else {
                reject({ code: status, response: this.responseText });
            }

        };
        xhttp.open("POST", url, true);
        xhttp.setRequestHeader('Content-type', 'application/json');
        xhttp.send(JSON.stringify(jsonParam));

    });

}

// main functionality

if (!isEmpty(getCookie('securityKey'))){
    window.location.assign("categories.php");
}

btnSubmit.addEventListener('click', function () {

    if (!showFeedback(feedbackPersonalEmail, validateFieldValue(inputPersonalEmail))) {
        return;
    }

    document.getElementById('div-message').style.display = 'none';
    document.getElementById('myIcon').classList.remove('ri-arrow-right-line');
    document.getElementById('myIcon').classList.add('ri-loader-2-line');

    let endpointUrl = baseUrl+"v1/web/auth/forgot";
    forgotUserEndpoint({

            email : inputPersonalEmail.value

        },
        endpointUrl)
        .then(response => JSON.parse(response))
        .then(data => {

            window.location.replace('verification.php?id='+data.data.id+"&email="+data.data.email+"&type=forgot");

        })
        .catch(error => {

            let responseData = JSON.parse(error.response);

            document.getElementById('div-message').innerText = responseData.message;
            document.getElementById('div-message').style.display = 'block';
            document.getElementById('myIcon').classList.remove('ri-loader-2-line');
            document.getElementById('myIcon').classList.add('ri-arrow-right-line');

        });


});

// utility functions - start

/* check either value is empty or not*/
function isEmpty(value) {
    return (typeof value === "undefined" || value === null || value === "");
}

/* for validate field either empty or not */
function validateFieldValue(inputField) {

    if (isEmpty(inputField.value)) {
        return false;
    } else {
        return true;
    }

}

/* show required feedback if empty*/
function showFeedback(inputField, emptyOrNot) {

    if (!emptyOrNot) {
        inputField.style.display = 'block';
    } else {
        inputField.style.display = 'none';
    }

    return emptyOrNot;

}

function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

