
let baseUrl02 = document.getElementById('id-base-url').value;
let userId02 = document.getElementById('input-user-id').value;
let securityKey02 = document.getElementById('input-security-key').value;

/* fetch operation record endpoint */
function fetchOperationRecordEndpoints(jsonParam, url = baseUrl02 + "api/auth/simple/operation_credits/fetch") {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200) {
                resolve(this.responseText);
            } else {
                reject(status);
            }

        };
        xhttp.open("POST", url, true);
        xhttp.setRequestHeader('Content-type', 'application/json');
        xhttp.setRequestHeader('Security-Key', securityKey02);
        xhttp.setRequestHeader('User-Id', userId02);
        xhttp.send(JSON.stringify(jsonParam));

    });

}

/* fetch operation record endpoint */
function fetchActivePackageEndpoints(jsonParam, url = baseUrl02 + "api/auth/simple/active_package/fetch") {
    return new Promise(function (resolve, reject) {

        const xhttp = new XMLHttpRequest();
        xhttp.onload = function () {

            var status = xhttp.status;
            if (status === 200) {
                resolve(this.responseText);
            } else {
                reject(status);
            }

        };
        xhttp.open("POST", url, true);
        xhttp.setRequestHeader('Content-type', 'application/json');
        xhttp.setRequestHeader('Security-Key', securityKey02);
        xhttp.setRequestHeader('User-Id', userId02);
        xhttp.send(JSON.stringify(jsonParam));

    });

}


(async function () {

    let jsonParam = {
        user_id : userId02
    };
    let fetchOperationRecordData = await fetchOperationRecordEndpoints(jsonParam);
    let fetchOperationRecordDataJson = JSON.parse(fetchOperationRecordData);
    if (fetchOperationRecordDataJson.code === "202") {

        if (fetchOperationRecordDataJson.data.length > 0){

            let operationCredits = fetchOperationRecordDataJson.data[0]['operation_credits'];
            document.getElementById('input-operations').innerText = operationCredits;

        }

    }
    else if (fetchOperationRecordDataJson.code === "209"){

        let isLogin = sessionStorage.setItem('login', false);
        window.location.replace("login.php");

    }


    let activePackageJsonParam = {
        user_id : userId02
    };
    let fetchActivePackageData = await fetchActivePackageEndpoints(activePackageJsonParam);
    let fetchActivePackageDataJson = JSON.parse(fetchActivePackageData);
    if (fetchActivePackageDataJson.code === "202") {

        if (fetchActivePackageDataJson.data.length > 0){

            let packageId = fetchActivePackageDataJson.data[0]['package_id'];
            if (packageId.startsWith("0") || packageId === 'null'){

                document.getElementById('input-role').classList.add('fw-semibold');
                document.getElementById('input-role').classList.add('text-danger');
                document.getElementById('input-role').innerHTML = 'Free Trial';

            }
            else {

                document.getElementById('input-role').classList.add('fw-semibold');
                document.getElementById('input-role').classList.add('text-success');
                document.getElementById('input-role').innerHTML = 'Paid Package';

            }

        }

    }


})();
